% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-deep-learning.R
\name{tl_fit_deep}
\alias{tl_fit_deep}
\title{Fit a deep learning model}
\usage{
tl_fit_deep(
  data,
  formula,
  is_classification = FALSE,
  hidden_layers = c(32, 16),
  activation = "relu",
  dropout = 0.2,
  epochs = 30,
  batch_size = 32,
  validation_split = 0.2,
  verbose = 0,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{hidden_layers}{Vector of units in each hidden layer (default: c(32, 16))}

\item{activation}{Activation function for hidden layers (default: "relu")}

\item{dropout}{Dropout rate for regularization (default: 0.2)}

\item{epochs}{Number of training epochs (default: 30)}

\item{batch_size}{Batch size for training (default: 32)}

\item{validation_split}{Proportion of data for validation (default: 0.2)}

\item{verbose}{Verbosity mode (0 = silent, 1 = progress bar, 2 = one line per epoch) (default: 0)}

\item{...}{Additional arguments}
}
\value{
A fitted deep learning model
}
\description{
Fit a deep learning model
}
\keyword{internal}
