% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{tl_add_cluster_features}
\alias{tl_add_cluster_features}
\title{Cluster-Based Features}
\usage{
tl_add_cluster_features(data, response = NULL, method = "kmeans", ...)
}
\arguments{
\item{data}{A data frame}

\item{response}{Response variable name (will be excluded from clustering)}

\item{method}{Clustering method: "kmeans", "pam", "hclust", "dbscan"}

\item{...}{Additional arguments for clustering}
}
\value{
Original data with cluster assignment column(s) added
}
\description{
Add cluster assignments as features for supervised learning.
This semi-supervised approach can capture non-linear patterns.
}
\examples{
\donttest{
# Add cluster features before supervised learning
data_with_clusters <- tl_add_cluster_features(iris, response = "Species",
                                                method = "kmeans", k = 3)
model <- tl_model(data_with_clusters, Species ~ ., method = "forest")
}
}
