% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_combine.R
\name{geo_combine}
\alias{geo_combine}
\title{Combine multiple geocoding queries}
\usage{
geo_combine(
  queries,
  global_params = list(),
  address = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  postalcode = NULL,
  country = NULL,
  lat = lat,
  long = long,
  ...
)
}
\arguments{
\item{queries}{a list of queries, each provided as a list of parameters. The queries are, executed by the \link{geocode} function in the order provided., (ex. \code{list(list(method = 'osm'), list(method = 'census'), ...)})}

\item{global_params}{a list of parameters to be used for all queries, (ex. \code{list(address = 'address', full_results = TRUE)})}

\item{address}{single line address (ie. '1600 Pennsylvania Ave NW, Washington, DC').
Do not combine with the address component arguments below
(\code{street}, \code{city}, \code{county}, \code{state}, \code{postalcode}, \code{country}).}

\item{street}{street address (ie. '1600 Pennsylvania Ave NW')}

\item{city}{city (ie. 'Tokyo')}

\item{county}{county (ie. 'Jefferson')}

\item{state}{state (ie. 'Kentucky')}

\item{postalcode}{postalcode (ie. zip code if in the United States)}

\item{country}{country (ie. 'Japan')}

\item{lat}{latitude column name. Can be quoted or unquoted (ie. \code{lat} or \code{"lat"}).}

\item{long}{longitude column name. Can be quoted or unquoted (ie. \code{long} or \code{"long"}).}

\item{...}{arguments passed to the \link{geocode_combine} function}
}
\value{
tibble (dataframe)
}
\description{
Passes address inputs in character vector form to the
\link{geocode_combine} function for geocoding.

Note that address inputs must be specified for queries either with the \code{queries} parameter (for each query)
or the \code{global_params} parameter (for all queries). For example \code{global_params = list(address = 'address')}
passes addresses provided in the \code{address} parameter to all queries.
}
\examples{
\donttest{

options(tidygeocoder.progress_bar = FALSE)
example_addresses <- c("100 Main St New York, NY", "Paris", "Not a Real Address")

geo_combine(
  queries = list(
    list(method = "census"),
    list(method = "osm")
  ),
  address = example_addresses,
  global_params = list(address = "address")
)

geo_combine(
  queries = list(
    list(method = "arcgis"),
    list(method = "census", mode = "single"),
    list(method = "census", mode = "batch")
  ),
  global_params = list(address = "address"),
  address = example_addresses,
  cascade = FALSE,
  return_list = TRUE
)

geo_combine(
  queries = list(
    list(method = "arcgis", address = "city"),
    list(method = "osm", city = "city", country = "country")
  ),
  city = c("Tokyo", "New York"),
  country = c("Japan", "United States"),
  cascade = FALSE
)
}
}
\seealso{
\link{geocode_combine} \link{geo} \link{geocode}
}
