% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_WSDI}
\alias{calculate_WSDI}
\title{Calculate Warm Spell Duration Index (WSDI)}
\usage{
calculate_WSDI(
  df,
  frequency = "daily",
  time_col = NULL,
  tmax_col = NULL,
  temp_col = NULL,
  window_days = 30,
  min_consecutive = 6
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmax_col}{Name of maximum temperature column (daily data) (string)}

\item{temp_col}{Name of temperature column (for single temp or hourly) (string)}

\item{window_days}{Window size for percentile calculation (default: 30)}

\item{min_consecutive}{Minimum consecutive days for warm spell (default: 6)}
}
\value{
A tibble with columns: year, WSDI, n_spells, mean_spell_length
}
\description{
Calculates the number of days with at least 6 consecutive days
where temperature exceeds the 90th percentile, following ETCCDI
definition WSDI.
}
\examples{
# Daily data with maximum temperature
set.seed(123)
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmax = 25 + 10 * sin(seq(0, 4*pi, length.out = 1096)) + rnorm(1096, 0, 5)
)

calculate_WSDI(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax"
)

# With custom window and consecutive days
calculate_WSDI(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax",
  window_days = 15,
  min_consecutive = 5
)
}
