% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdt_url.R
\name{tdt_chunk}
\alias{tdt_chunk}
\title{Create a Link to Tidy Data Tutor from an R Code Chunk}
\usage{
tdt_chunk(chunk)
}
\arguments{
\item{chunk}{The name of an R code chunk in the current R Markdown document.}
}
\value{
A string with an appropriately formatted URL to Tidy Data Tutor.
}
\description{
Create a Link to Tidy Data Tutor from an R Code Chunk
}
\examples{
\dontrun{

<!--- In an R Markdown document: --->
```{r mtcars-1}
library(dplyr)

mtcars \%>\%
  select(mpg, cyl, hp) \%>\%
  group_by(cyl) \%>\%
  summarise(mean(hp))
```

[See this pipeline in Tidy Data Tutor](`r tdt_chunk("mtcars-1")`)
}
}
