% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-grants.R
\name{tsg_search_grants}
\alias{tsg_search_grants}
\title{Search for specific datasets}
\usage{
tsg_search_grants(
  search,
  search_in = NULL,
  verbose = TRUE,
  ignore_case = TRUE,
  perl = FALSE,
  fixed = FALSE,
  ...
)
}
\arguments{
\item{search}{The string(s) to search for. By default allows POSIX 1003.2
regular expressions. Use \code{perl = TRUE} for perl-style regex, or
\code{fixed = TRUE} for fixed strings.
Accepts single strings or a character vector of strings.}

\item{search_in}{The name of the column to search in. Accepts single strings
or a character vector of column names. If \code{NULL}, searches all columns.}

\item{verbose}{If \code{TRUE}, prints console messages on data retrieval progress.
Defaults to \code{TRUE}.}

\item{ignore_case}{If \code{TRUE} ignores case.}

\item{perl}{If \code{TRUE}, uses perl-style regex.}

\item{fixed}{If \code{TRUE}, searches will be matched as-is.}

\item{...}{Additional params passed to \code{\link[=tsg_all_grants]{tsg_all_grants()}}}
}
\value{
A single tibble (if only one grant maker matches the queries) or a
list of tibbles (if the query matches multiple datasets).
}
\description{
Returns a list of tibbles with details of all grants from specific funders.
}
\details{
\code{tsg_search_grants} retrieves grants where funder data
matches one or more search strings. If only one dataset
matches queries, returns a tibble of that dataset.
Use \code{\link[=tsg_specific_df]{tsg_specific_df()}} to pass a dataframe.
}
\examples{
\dontrun{
specific1 <- tsg_search_grants(search = c("bbc", "caBinet"))
}

}
\seealso{
\code{\link[=tsg_search_funders]{tsg_search_funders()}} for retrieving information on available
datasets from matching funders. \code{\link[=tsg_specific_df]{tsg_specific_df()}} to retrieve data
contained with all or specific rows of a tibble returned
by \code{\link[=tsg_available]{tsg_available()}} or \code{\link[=tsg_missing]{tsg_missing()}}.
}
