% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_vars}
\alias{get_vars}
\title{Get used vars in a ggplot object}
\usage{
get_vars(p, reverse = FALSE, verbose = TRUE)
}
\arguments{
\item{p}{A \code{ggplot} object.}

\item{reverse}{Whether to return unused vars.
Default is \code{FALSE}.}

\item{verbose}{Whether to print the message.
Default is \code{TRUE}.}
}
\value{
A character vector of variable names.
If \code{reverse} is \code{FALSE}, returns used variables;
if \code{TRUE}, returns unused variables.
}
\description{
Get used vars in a ggplot object
}
\examples{
library(ggplot2)
p <- ggplot(
  data = mtcars,
  aes(x = mpg, y = wt, colour = cyl)
) +
  geom_point()
get_vars(p)
get_vars(p, reverse = TRUE)
}
