% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_linear_regression}
\alias{sts_linear_regression}
\title{Formal representation of a linear regression from provided covariates.}
\usage{
sts_linear_regression(design_matrix, weights_prior = NULL, name = NULL)
}
\arguments{
\item{design_matrix}{float \code{tensor} of shape \code{tf$concat(list(batch_shape, list(num_timesteps, num_features)))}.
This may also optionally be an instance of \code{tf$linalg$LinearOperator}.}

\item{weights_prior}{\code{Distribution} representing a prior over the regression
weights. Must have event shape \code{list(num_features)} and batch shape
broadcastable to the design matrix's \code{batch_shape}. Alternately,
\code{event_shape} may be scalar (\code{list()}), in which case the prior is
internally broadcast as
\code{tfd_transformed_distribution(weights_prior, tfb_identity(), event_shape = list(num_features), batch_shape = design_matrix$batch_shape)}.
If \code{NULL}, defaults to \code{tfd_student_t(df = 5, loc = 0, scale = 10)},
a weakly-informative prior loosely inspired by the
\href{https://github.com/stan-dev/stan/wiki/Prior-Choice-Recommendations}{Stan prior choice recommendations}.
Default value: \code{NULL}.}

\item{name}{the name of this model component. Default value: 'LinearRegression'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
This model defines a time series given by a linear combination of
covariate time series provided in a design matrix:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observed_time_series <- tf$matmul(design_matrix, weights)
}\if{html}{\out{</div>}}
}
\details{
The design matrix has shape \code{list(num_timesteps, num_features)}.
The weights are treated as an unknown random variable of size \code{list(num_features)}
(both components also support batch shape), and are integrated over using the same
approximate inference tools as other model parameters, i.e., generally HMC or
variational inference.

This component does not itself include observation noise; it defines a
deterministic distribution with mass at the point
\code{tf$matmul(design_matrix, weights)}. In practice, it should be combined with
observation noise from another component such as \code{sts_sum}, as demonstrated below.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
