% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{tile_batch}
\alias{tile_batch}
\title{Tile batch}
\usage{
tile_batch(t, multiplier, name = NULL)
}
\arguments{
\item{t}{`Tensor` shaped `[batch_size, ...]`.}

\item{multiplier}{Python int.}

\item{name}{Name scope for any created operations.}
}
\value{
A (possibly nested structure of) `Tensor` shaped `[batch_size * multiplier, ...]`.
}
\description{
Tile the batch dimension of a (possibly nested structure of) tensor(s)
}
\details{
t. For each tensor t in a (possibly nested structure) of tensors,
this function takes a tensor t shaped `[batch_size, s0, s1, ...]` composed
of minibatch entries `t[0], ..., t[batch_size - 1]` and tiles it to have a
shape `[batch_size * multiplier, s0, s1, ...]` composed of minibatch
entries `t[0], t[0], ..., t[1], t[1], ...` where each minibatch entry is
repeated `multiplier` times.
}
\section{Raises}{

ValueError: if tensor(s) `t` do not have a statically known rank or the rank is < 1.
}

