% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2seq.R
\name{sampler_sample_embedding}
\alias{sampler_sample_embedding}
\title{Sample Embedding Sampler}
\usage{
sampler_sample_embedding(
  embedding_fn = NULL,
  softmax_temperature = NULL,
  seed = NULL
)
}
\arguments{
\item{embedding_fn}{(Optional) A callable that takes a vector tensor of ids (argmax ids),
or the params argument for embedding_lookup. The returned tensor will be passed to the
decoder input.}

\item{softmax_temperature}{(Optional) float32 scalar, value to divide the logits by
before computing the softmax. Larger values (above 1.0) result in more random samples,
while smaller values push the sampling distribution towards the argmax. Must be strictly
greater than 0. Defaults to 1.0.}

\item{seed}{(Optional) The sampling seed.}
}
\value{
None
}
\description{
A sampler for use during inference.
}
\details{
Uses sampling (from a distribution) instead of argmax and passes
the result through an embedding layer to get the next input.
}
