% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_rsquare}
\alias{metric_rsquare}
\title{RSquare

This is also called as coefficient of determination. It tells how close
are data to the fitted regression line. Highest score can be 1.0 and it
indicates that the predictors perfectly accounts for variation in the target.
Score 0.0 indicates that the predictors do not account for variation in the
target. It can also be negative if the model is worse.}
\usage{
metric_rsquare(
  name = "r_square",
  dtype = tf$float32,
  ...,
  multioutput = "uniform_average"
)
}
\arguments{
\item{name}{(Optional) String name of the metric instance.}

\item{dtype}{(Optional) Data type of the metric result. Defaults to `tf$float32`.}

\item{...}{additional arguments to pass}

\item{multioutput}{one of the following: "raw_values", "uniform_average", "variance_weighted"}
}
\value{
r squared score: float
}
\description{
RSquare

This is also called as coefficient of determination. It tells how close
are data to the fitted regression line. Highest score can be 1.0 and it
indicates that the predictors perfectly accounts for variation in the target.
Score 0.0 indicates that the predictors do not account for variation in the
target. It can also be negative if the model is worse.
}
\examples{

\dontrun{

actuals = tf$constant(c(1, 4, 3), dtype=tf$float32)
preds = tf$constant(c(2, 4, 4), dtype=tf$float32)
result = metric_rsquare()
result$update_state(actuals, preds)
paste('R^2 score is: ', r1$result()$numpy()) # 0.57142866

}
}
