% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnn.R
\name{layer_nas_cell}
\alias{layer_nas_cell}
\title{Neural Architecture Search (NAS) recurrent network cell.}
\usage{
layer_nas_cell(
  object,
  units,
  projection = NULL,
  use_bias = FALSE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "glorot_uniform",
  projection_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  ...
)
}
\arguments{
\item{object}{Model or layer object}

\item{units}{int, The number of units in the NAS cell.}

\item{projection}{(optional) int, The output dimensionality for the projection matrices.
If None, no projection is performed.}

\item{use_bias}{(optional) bool, If `TRUE` then use biases within the cell.
This is `FALSE` by default.}

\item{kernel_initializer}{Initializer for kernel weight.}

\item{recurrent_initializer}{Initializer for recurrent kernel weight.}

\item{projection_initializer}{Initializer for projection weight, used when projection
is not `NULL`.}

\item{bias_initializer}{Initializer for bias, used when `use_bias` is `TRUE`.}

\item{...}{Additional keyword arguments.}
}
\value{
A tensor
}
\description{
Neural Architecture Search (NAS) recurrent network cell.
}
\details{
This implements the recurrent cell from the paper: https://arxiv.org/abs/1611.01578
Barret Zoph and Quoc V. Le. "Neural Architecture Search with Reinforcement Learning"
Proc. ICLR 2017. The class uses an optional projection layer.
}
