% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_dense_image_warp}
\alias{img_dense_image_warp}
\title{Dense image warp}
\usage{
img_dense_image_warp(image, flow, name = NULL)
}
\arguments{
\item{image}{4-D float Tensor with shape [batch, height, width, channels].}

\item{flow}{A 4-D float Tensor with shape [batch, height, width, 2].}

\item{name}{A name for the operation (optional).}
}
\value{
A 4-D float `Tensor` with shape`[batch, height, width, channels]` and same type as input image.
}
\description{
Image warping using per-pixel flow vectors.
}
\details{
Apply a non-linear warp to the image, where the warp is specified by a
dense flow field of offset vectors that define the correspondences of
pixel values in the output image back to locations in the source image.
Specifically, the pixel value at output[b, j, i, c] is
images[b, j - flow[b, j, i, 0], i - flow[b, j, i, 1], c]. The locations specified by
this formula do not necessarily map to an int
index. Therefore, the pixel value is obtained by bilinear
interpolation of the 4 nearest pixels around
(b, j - flow[b, j, i, 0], i - flow[b, j, i, 1]). For locations outside
of the image, we use the nearest pixel values at the image boundary.
}
\note{
Note that image and flow can be of type tf$half, tf$float32, or tf$float64, and
do not necessarily have to be the same type.
}
\section{Raises}{

ValueError: if height < 2 or width < 2 or the inputs have the wrong number of dimensions.
}

\examples{

\dontrun{
flow_shape = list(1L, as.integer(input_img$shape[[2]]), as.integer(input_img$shape[[3]]), 2L)
init_flows = tf$random$normal(flow_shape) * 2.0
dense_img_warp = img_dense_image_warp(input_img, init_flows)
dense_img_warp = tf$squeeze(dense_img_warp, 0)
}


}
