% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textra.R
\name{textra}
\alias{textra}
\title{Translate text using Transliteration Model}
\usage{
textra(text, params, model = "transLM", from = "en", to = "ja")
}
\arguments{
\item{text}{The text to be translated.}

\item{params}{A list of parameters to be passed to the API.}

\item{model}{The model to be used for translation.}

\item{from}{The source language.}

\item{to}{The target language.}
}
\value{
The translated text.
}
\description{
This function translates text using a transliteration model.
}
\examples{
\dontrun{
text <- "Hello world"
key <- "abcdefghijklmnopqrstuvw01234567890abcdef1" # API key
secret <- "xyzabcdefghijklmnopqrstuvw012345"       # API secret
name <- "login_ID"                                 # login_ID
params <- gen_params(key = key, secret = secret, name = name)
translated <- 
  textra(text, params, model = "transLM", from = "en", to = "ja")
translated
}

}
