% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_huggingface_embeddings.R
\name{api_huggingface_embeddings}
\alias{api_huggingface_embeddings}
\title{Call Hugging Face API for Embeddings}
\usage{
api_huggingface_embeddings(
  tif,
  text_hierarchy,
  api_token,
  api_url = NULL,
  query = NULL,
  dims = 384,
  batch_size = 250,
  sleep_duration = 1,
  verbose = TRUE
)
}
\arguments{
\item{tif}{A data frame containing text data.}

\item{text_hierarchy}{A character vector indicating the columns used to create row names.}

\item{api_token}{Token for accessing the Hugging Face API.}

\item{api_url}{The URL of the Hugging Face API endpoint (default is all-MiniLM-L6-v2).}

\item{query}{An optional single text query for which embeddings are required.}

\item{dims}{The dimension of the output embeddings.}

\item{batch_size}{Number of rows in each batch sent to the API.}

\item{sleep_duration}{Duration in seconds to pause between processing batches.}

\item{verbose}{A boolean specifying whether to include progress bar}
}
\value{
A matrix containing embeddings, with each row corresponding to a text input.
}
\description{
Retrieves embeddings for text data using Hugging Face's API. It can process a batch of texts or a single query.  Mostly for demo purposes.
}
\examples{
\dontrun{
tif <- data.frame(doc_id = c('1'), text = c("Hello world."))
embeddings <- api_huggingface_embeddings(tif,
                                         text_hierarchy = 'doc_id',
                                         api_token = api_token)
}


}
