% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{flag_words}
\alias{flag_words}
\title{Flag rows in a text.table with specific words}
\usage{
flag_words(x, text, flag = "flag", words)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x to check for words to flag.}

\item{flag}{A string, the name of the column created with the flag indicator.}

\item{words}{A vector of words to flag x.}
}
\value{
A text.table, with rows marked with a 1 if the words in those rows are in the vector of words to delete, otherwise 0.
}
\description{
Flag rows in a text.table with specific words
}
\examples{
flag_words(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2",
flag = "is_stopword",
words = stopwords
)
}
