% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_no_error.R
\name{ttm_expect_no_error}
\alias{ttm_expect_no_error}
\title{Test that multi: expect no error}
\usage{
ttm_expect_no_error(object, message = NULL, class = NULL, verbose = 0)
}
\arguments{
\item{object}{Object to test.}

\item{message}{Passed to `testthat::expect_no_error()`.}

\item{class}{Passed to `testthat::expect_no_error()`.}

\item{verbose}{Amount of info that should be printed.}
}
\value{
Test result
}
\description{
See `testthat::expect_no_error` for details.
}
\examples{
set.seed(0)

# 1 attempt, all pass
ttm(1, {
  ttm_expect_no_error(1)
})

# Fails first ~10 times, then passes
ttm(100, {
  ttm_expect_no_error({
    if (runif(1) > 0.1) {
      print(1)
      stop('give error')
    }
  })
})

# Will always fail regardless of number of attempts
try({
  ttm(3, {
    ttm_expect_no_error(stop('error'))
  })
})
}
