% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{network_initialize}
\alias{network_initialize}
\title{Initialize Network Object}
\usage{
network_initialize(
  n,
  directed = FALSE,
  hyper = FALSE,
  loops = FALSE,
  multiple = FALSE,
  bipartite = FALSE
)
}
\arguments{
\item{n}{Network size.}

\item{directed}{logical; should edges be interpreted as directed?}

\item{hyper}{logical; are hyperedges allowed?}

\item{loops}{logical; should loops be allowed?}

\item{multiple}{logical; are multiplex edges allowed?}

\item{bipartite}{count; should the network be interpreted as bipartite? If
present (i.e., non-NULL) it is the count of the number of actors in the
first mode of the bipartite network. In this case, the overall number
of vertices is equal to the number of 'actors' (first mode) plus the
number of ‘events’ (second mode), with the vertex.ids of all actors
preceeding all events. The edges are then interpreted as nondirected.}
}
\value{
Returns an object of class \code{network}.
}
\description{
Initialize an undirected network object for use in EpiModel
             workflows.
}
\details{
This function is used in \code{EpiModel} workflows to initialize an empty
network object with the directed network attribute hard set to \code{FALSE}.
}
\examples{
\dontrun{
nw <- network_initialize(100)
nw
}

}
