% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_write_update.R
\name{write_update_data}
\alias{write_update_data}
\title{Write or update the sensor data in the data folder}
\usage{
write_update_data(segment_name, start_date, end_date, create_directory = FALSE)
}
\arguments{
\item{segment_name}{Character. Name of the segment, as specified in config.}

\item{start_date}{Date. Start date "aaaa-mm-jj"}

\item{end_date}{Date. End date "aaaa-mm-jj"}

\item{create_directory}{Boolean: Does the file need to be created in the project directory? Default to FALSE.}
}
\value{
Boolean: TRUE if the data is well saved/written, FALSE otherwise (no data for example)
}
\description{
Writes or updates the sensor data in the data folder.
It retrieves the data for the specified sensor between \code{start_date}
and \code{end_date} (inclusive) using the \code{retrieve_sensor} function,
and then converts certain columns to character strings before writing the data
to a RData file in the \code{data} folder (if \code{create_directory = TRUE}),
to a temporary folder otherwise.
}
\examples{
\dontrun{ # This function requires a valid API key
period <- as.Date(c('2022-01-01', '2022-12-31'))
write_update_data('RteVitre-06', period[1], period[2])
}

}
