% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_global.R
\name{filter_agg}
\alias{filter_agg}
\title{Filter by selected criteria and aggregating traffics.}
\usage{
filter_agg(
  data,
  date_range = NULL,
  segments = NULL,
  direction = NULL,
  modes = NULL,
  weekdays = NULL,
  hours = NULL,
  uptime_quality = TRUE
)
}
\arguments{
\item{data}{Traffic Data Frame}

\item{date_range}{Date vector, c("aaaa-mm-jj","aaaa-mm-jj")}

\item{segments}{Vector of character. Ids of desired segments.}

\item{direction}{Vector of character. Direction of the street (lft, right, both).}

\item{modes}{Vector of character. Type(s) of mobility: c("car","heavy","pedestrian","bike")}

\item{weekdays}{Vector of character. Weekday(s) choosen.}

\item{hours}{Integer vector. Hours choosen, default to the all day.}
}
\value{
the filtered data, molten by mode and direction, with new columns :
\itemize{
\item \code{mode}, the mode, one row per different transportation mode + date/hour + direction
\item \code{direction}, the direction, one row per different transportation mode + date/hour + direction
\item \code{traffic_sum}, the traffic for this mode/direction on this specific date/hour
}
}
\description{
Not all criteria need to be filled in. Unfilled criteria are set by default so that no filtering is performed.
}
\examples{
date_range = as.Date(c('2022-01-01','2022-01-08'))
filter_agg(traffic,
  date_range = date_range,
  segments = 'RteVitre-06',
  direction = 'lft',
  modes = 'pedestrian',
  weekdays = 'saturday',
  hours = 12:14,
  uptime_quality = TRUE
  )
}
\keyword{internal}
