% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residency_plot.R
\name{residence_plot}
\alias{residence_plot}
\title{Residency Survival Plot}
\usage{
residence_plot(time_df, var_groups = NULL, time_unit)
}
\arguments{
\item{time_df}{a dataframe created by duration compare showing the proportion
of events created by each potential blanking period which "survived" a
certain time (t)}

\item{var_groups}{a single string or vector of strings of the columns which
should be used to group organisms. Common groupings are species and cohorts.}

\item{time_unit}{the unit of time used to calculate durations}
}
\value{
A plot of the proportion of events created by each potential
blanking period at each time (t).
}
\description{
Takes a dataframe of the proportion of events created by each potential
blanking period which "survived" a certain time (t) and creates a plot.
Used to visually look for convergences between survival lines.
}
\examples{
#Plot a comparison of the number of events longer than a given time `t`
residence_plot(time_df = time_test,
               var_groups = "fish_type",
               time_unit = "secs")
# Note: that the large number of lines extending past the largest Time
# indicates that a larger t is needed to ensure convergence
}
