% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_rSSR.R
\name{renorm_SSR}
\alias{renorm_SSR}
\title{Calculate the Renormalized Sum of Squared Residuals}
\usage{
renorm_SSR(time_df, var_groups = NULL)
}
\arguments{
\item{time_df}{a dataframe created by duration compare showing the proportion
of events created by each potential blanking period which "survived" a
certain time (t)}

\item{var_groups}{a single string or vector of strings of the columns which
should be used to group organisms. Common groupings are species and cohorts.}
}
\value{
A dataframe of the renormalized sum of squared residuals between each
potential blanking period and the subsequent one.
}
\description{
Takes a dataframe of the proportion of events created by each potential
blanking period which "survived" a certain time (t) created by
`duration_compare()` and calculates the sum of squares of the residuals
between one potential blanking period and the next. This result is then
renormalized by dividing the result by the number of events created.
}
