% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterStateDate.R
\docType{class}
\name{DateFilterState}
\alias{DateFilterState}
\title{\code{FilterState} object for \code{Date} data}
\description{
Manages choosing a range of \code{Date}s.
}
\examples{
# use non-exported function from teal.slice
include_css_files <- getFromNamespace("include_css_files", "teal.slice")
include_js_files <- getFromNamespace("include_js_files", "teal.slice")
DateFilterState <- getFromNamespace("DateFilterState", "teal.slice")

library(shiny)

filter_state <- DateFilterState$new(
  x = c(Sys.Date() + seq(1:10), NA),
  slice = teal_slice(varname = "x", dataname = "data"),
  extract_type = character(0)
)
isolate(filter_state$get_call())
filter_state$set_state(
  teal_slice(
    dataname = "data",
    varname = "x",
    selected = c(Sys.Date() + 3L, Sys.Date() + 8L),
    keep_na = TRUE
  )
)
isolate(filter_state$get_call())

# working filter in an app
library(shinyjs)

dates <- c(Sys.Date() - 100, Sys.Date())
data_date <- c(seq(from = dates[1], to = dates[2], length.out = 100), NA)
fs <- DateFilterState$new(
  x = data_date,
  slice = teal_slice(
    dataname = "data", varname = "x", selected = data_date[c(47, 98)], keep_na = TRUE
  )
)

ui <- bslib::page_fluid(
  useShinyjs(),
  include_css_files(pattern = "filter-panel"),
  include_js_files(pattern = "count-bar-labels"),
  bslib::layout_column_wrap(
    width = 1 / 3,
    tags$div(
      tags$h4("DateFilterState"),
      fs$ui("fs")
    ),
    tags$div(
      id = "outputs", # div id is needed for toggling the element
      tags$h4("Condition (i.e. call)"), # display the condition call generated by this FilterState
      textOutput("condition_date"), tags$br(),
      tags$h4("Unformatted state"), # display raw filter state
      textOutput("unformatted_date"), tags$br(),
      tags$h4("Formatted state"), # display human readable filter state
      textOutput("formatted_date"), tags$br()
    ),
    tags$div(
      tags$h4("Programmatic filter control"),
      actionButton("button1_date", "set drop NA", width = "100\%"), tags$br(),
      actionButton("button2_date", "set keep NA", width = "100\%"), tags$br(),
      actionButton("button3_date", "set a range", width = "100\%"), tags$br(),
      actionButton("button4_date", "set full range", width = "100\%"), tags$br(),
      actionButton("button0_date", "set initial state", width = "100\%"), tags$br()
    )
  )
)

server <- function(input, output, session) {
  fs$server("fs")
  output$condition_date <- renderPrint(fs$get_call())
  output$formatted_date <- renderText(fs$format())
  output$unformatted_date <- renderPrint(fs$get_state())
  # modify filter state programmatically
  observeEvent(
    input$button1_date,
    fs$set_state(teal_slice(dataname = "data", varname = "x", keep_na = FALSE))
  )
  observeEvent(
    input$button2_date,
    fs$set_state(teal_slice(dataname = "data", varname = "x", keep_na = TRUE))
  )
  observeEvent(
    input$button3_date,
    fs$set_state(teal_slice(dataname = "data", varname = "x", selected = data_date[c(34, 56)]))
  )
  observeEvent(
    input$button4_date,
    fs$set_state(teal_slice(dataname = "data", varname = "x", selected = dates))
  )
  observeEvent(
    input$button0_date,
    fs$set_state(
      teal_slice("data", "variable", selected = data_date[c(47, 98)], keep_na = TRUE)
    )
  )
}

if (interactive()) {
  shinyApp(ui, server)
}

}
\keyword{internal}
\section{Super class}{
\code{\link[teal.slice:FilterState]{teal.slice::FilterState}} -> \code{DateFilterState}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DateFilterState-new}{\code{DateFilterState$new()}}
\item \href{#method-DateFilterState-get_call}{\code{DateFilterState$get_call()}}
\item \href{#method-DateFilterState-clone}{\code{DateFilterState$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="destroy"><a href='../../teal.slice/html/FilterState.html#method-FilterState-destroy'><code>teal.slice::FilterState$destroy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="format"><a href='../../teal.slice/html/FilterState.html#method-FilterState-format'><code>teal.slice::FilterState$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="get_state"><a href='../../teal.slice/html/FilterState.html#method-FilterState-get_state'><code>teal.slice::FilterState$get_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="print"><a href='../../teal.slice/html/FilterState.html#method-FilterState-print'><code>teal.slice::FilterState$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="server"><a href='../../teal.slice/html/FilterState.html#method-FilterState-server'><code>teal.slice::FilterState$server()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="set_state"><a href='../../teal.slice/html/FilterState.html#method-FilterState-set_state'><code>teal.slice::FilterState$set_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="ui"><a href='../../teal.slice/html/FilterState.html#method-FilterState-ui'><code>teal.slice::FilterState$ui()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DateFilterState-new"></a>}}
\if{latex}{\out{\hypertarget{method-DateFilterState-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{FilterState} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateFilterState$new(
  x,
  x_reactive = reactive(NULL),
  slice,
  extract_type = character(0)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{Date})
variable to be filtered.}

\item{\code{x_reactive}}{(\code{reactive})
returning vector of the same type as \code{x}. Is used to update
counts following the change in values of the filtered dataset.
If it is set to \code{reactive(NULL)} then counts based on filtered
dataset are not shown.}

\item{\code{slice}}{(\code{teal_slice})
specification of this filter state.
\code{teal_slice} is stored in the object and \code{set_state} directly manipulates values within \code{teal_slice}.
\code{get_state} returns \code{teal_slice} object which can be reused in other places.
Note that \code{teal_slice} is a \code{reactiveValues}, which means it has reference semantics, i.e.
changes made to an object are automatically reflected in all places that refer to the same \code{teal_slice}.}

\item{\code{extract_type}}{(\code{character})
specifying whether condition calls should be prefixed by \code{dataname}. Possible values:
\itemize{
\item \code{character(0)} (default) \code{varname} in the condition call will not be prefixed
\item \code{"list"} \code{varname} in the condition call will be returned as \verb{<dataname>$<varname>}
\item \code{"matrix"} \code{varname} in the condition call will be returned as \verb{<dataname>[, <varname>]}
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{DateFilterState}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DateFilterState-get_call"></a>}}
\if{latex}{\out{\hypertarget{method-DateFilterState-get_call}{}}}
\subsection{Method \code{get_call()}}{
Returns reproducible condition call for current selection.
For this class returned call looks like
\verb{<varname> >= <min value> & <varname> <= <max value>} with optional \verb{is.na(<varname>)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateFilterState$get_call(dataname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataname}}{(\code{character(1)}) containing possibly prefixed name of data set}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{call} or \code{NULL}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DateFilterState-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DateFilterState-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateFilterState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
