% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_abnormality_by_worst_grade.R
\name{template_abnormality_by_worst_grade}
\alias{template_abnormality_by_worst_grade}
\title{Template: Laboratory test results with highest grade post-baseline}
\usage{
template_abnormality_by_worst_grade(
  parentname,
  dataname,
  arm_var,
  id_var = "USUBJID",
  paramcd = "PARAMCD",
  atoxgr_var = "ATOXGR",
  worst_high_flag_var = "WGRHIFL",
  worst_low_flag_var = "WGRLOFL",
  worst_flag_indicator = "Y",
  add_total = FALSE,
  total_label = default_total_label(),
  drop_arm_levels = TRUE,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{id_var}{(\code{character})\cr the variable name for subject id.}

\item{paramcd}{(\code{character})\cr name of the parameter code variable.}

\item{atoxgr_var}{(\code{character})\cr name of the variable indicating
Analysis Toxicity Grade.}

\item{worst_high_flag_var}{(\code{character})\cr name of the variable indicating
Worst High Grade flag}

\item{worst_low_flag_var}{(\code{character})\cr name of the variable indicating
Worst Low Grade flag}

\item{worst_flag_indicator}{(\code{character})\cr flag value indicating the worst grade.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a table to summarize abnormality by grade.
}
\seealso{
\code{\link[=tm_t_abnormality_by_worst_grade]{tm_t_abnormality_by_worst_grade()}}
}
\keyword{internal}
