% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindex.R
\name{reindex}
\alias{reindex}
\alias{reindex.taxlist}
\alias{reindex,taxlist-method}
\alias{reindex<-}
\alias{reindex<-.taxlist}
\alias{reindex<-,taxlist-method}
\title{Re-index elements of taxlist objects}
\usage{
reindex(object, ...)

\method{reindex}{taxlist}(object, old, new, idx = "TaxonConceptID", ...)

reindex(object, ...) <- value

\method{reindex}{taxlist}(object, ...) <- value
}
\arguments{
\item{object}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments to be passed among methods.}

\item{old}{A vector with old identifiers to be re-indized. This may contain
all identifiers or only a part of them. If only a part, the rest of
indices will be preserved. If the changes insert duplicated identifiers,
an error message will be retrieved. If missing, all identifiers in
\code{'object'} will be considered.}

\item{new, value}{A vector with the new identifiers. It has to be of
the same length as \code{'old'}.}

\item{idx}{Name of the index to be changed, which means \code{"TaxonConceptID"},
\code{"TaxonUsageID"}, or \code{"ViewID"} for taxon concepts, taxon usage names, or
taxon views, respectively. You can also use the aliases \code{"concept"},
\code{"usage"}, and \code{"view"}.}
}
\value{
An object of class \linkS4class{taxlist} with modified identifiers.
}
\description{
The assignment of new identifiers must take into account all possible
occurrences of such indices in \linkS4class{taxlist} objects in order to maintain
their validity.
}
\examples{
## Copy taxonomic list
sp_list <- Easplist
summary(sp_list, "papyrus")

## Re-index taxon concepts
reindex(sp_list) <- id_generator(nrow(sp_list@taxonRelations),
    mode = "character")

## Re-index taxon usage names
reindex(sp_list, idx = "TaxonUsageID") <- id_generator(nrow(sp_list@taxonNames),
    mode = "character")

## Re-index taxon views
reindex(sp_list, idx = "ViewID") <- id_generator(nrow(sp_list@taxonViews),
    mode = "character")

## Check result
validObject(sp_list)
summary(sp_list, "papyrus")
}
