% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_classes.R
\name{tab_wrap_text}
\alias{tab_wrap_text}
\title{Wrap column names and character/factor variables.}
\usage{
tab_wrap_text(
  tabs,
  wrap_rows = 35L,
  wrap_cols = 15L,
  exdent = 1,
  whitespace_only = TRUE,
  unbreakable_spaces = TRUE,
  brk = "\\n"
)
}
\arguments{
\item{tabs}{A \code{tabxplor_tab} or a \code{tibble} .}

\item{wrap_rows}{By default, rownames are wrapped when larger than 30 characters.}

\item{wrap_cols}{By default, colnames are wrapped when larger than 12 characters.}

\item{exdent}{On the second lines or more, the number or characters to use for indentation.}

\item{whitespace_only}{Set to \code{FALSE} to wrap also on non whitespace characters.}

\item{unbreakable_spaces}{Set to \code{FALSE} to keep normal spaces in text (auto-break).}

\item{brk}{The string to use for linebreak : \verb{\\n} in text, but \verb{<br>} in html.}
}
\value{
The same \code{tabxplor_tab} or \code{tibble}.
}
\description{
Wrap column names and character/factor variables.
}
\examples{
\donttest{
tab(forcats::gss_cat, race, marital, pct = "row", color = "diff") |>
  tab_wrap_text(wrap_rows = 5L, wrap_cols = 8L)
}

}
