% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{table1}
\alias{table1}
\title{Table 1}
\usage{
table1(
  var,
  strata,
  data,
  normal = c("age", "bmi", "sbp", "dbp"),
  catDigits = 1,
  contDigits = 1,
  pDigits = 3,
  showAllLevels = FALSE
)
}
\arguments{
\item{var}{A vector of strings. Variables to be summarized given as a character vector.}

\item{strata}{A vector of strings. Stratifying (grouping) variable name(s) given as a character vector.}

\item{data}{A data frame in which these variables exist.}

\item{normal}{A vector of strings, default \code{= c("age", "bmi", "sbp", "dbp")}. Show the mean and standard deviation of some variables.}

\item{catDigits}{An integer, Number of decimal places in the table of continuous variables.}

\item{contDigits}{An integer, Number of decimal places in the table of categorical variables.}

\item{pDigits}{An integer, Number of decimal places in the table of p values.}

\item{showAllLevels}{Bool, default \code{= FALSE}. If TRUE, the table contains all levels of categorical variables.}
}
\value{
An object describing baseline characteristics.
}
\description{
Create an object summarizing all baseline variables ( both continuous and categorical ). The function is improved on the basis of tableone::CreateTableOne to become more convenient to use.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
## Make categorical variables factors
varsToFactor <- c('status','trt','ascites','hepato','spiders','edema','stage','sex')
pbc[varsToFactor] <- lapply(pbc[varsToFactor], factor)
##Table 1
table1(var=c('age','albumin','alk.phos','ast','edema','ascites','bili','chol'),strata='trt',pbc)
}
