% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{matDim.tableMatrix}
\alias{matDim.tableMatrix}
\alias{matDim<-.tableMatrix}
\title{Get or set matDim attribute}
\usage{
\method{matDim}{tableMatrix}(obj, matN = NULL, resetN = FALSE, ...)

\method{matDim}{tableMatrix}(obj) <- value
}
\arguments{
\item{obj}{\code{tableMatrix} object.}

\item{matN}{Integer. Matrix number in the matrix part list.}

\item{resetN}{Logical. When FALSE \code{tm.matN} of returned \code{matDim} won't be 
reset to 1.}

\item{...}{Passed arguments.}

\item{value}{data.table}
}
\value{
Full dimensions part of \code{tableMatrix} or a subset of dimensions part.
}
\description{
\code{tableMatrix} method to get or set matDim attribute.
}
\examples{

data(images8By8)
data(images10By10)

# Create tableMatrix from images8By8 and images10By10
TM <- tableMatrix(list(images8By8, images10By10), list(1:3, 1:3),
list(r=c(4,ncol(images8By8)),r=c(4,ncol(images10By10))))

# Dimensions part of TM
matDim(TM)

# Dimensions part of TM corresponding to matrix type 2
matDim(TM, 2)

}
