% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys_eval_cri.R
\name{sys_eval_cri}
\alias{sys_eval_cri}
\title{Build Transition Scores criteria}
\usage{
sys_eval_cri(binary_dataset, n_iter, vars_to_discretize = NULL)
}
\arguments{
\item{binary_dataset}{A binary dataframe of datasets used to establish evaluation criteria.}

\item{n_iter}{The number of iterations to reach the steady state.}

\item{vars_to_discretize}{Variables or columns to be discretized. Default is NULL.}
}
\value{
A dataframe containing the scores of nanomaterial features.
}
\description{
This function evaluates the criteria for a binary dataset by calculating the transfer probability matrix and iterating to obtain the transfer probability vector.
}
\examples{
data(dataset)
binary_dataset <- dataset
var_dis <- c("Synthesis methods", "pH", "Temperature (℃)",
"Zeta potential (mV)","Size (nm)", "Shape", "Applications")
criteria <- sys_eval_cri(binary_dataset, 6, var_dis)
}
