% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deduplication_functions.R
\name{extract_unique_references}
\alias{extract_unique_references}
\title{Remove duplicates from a bibliographic data set}
\usage{
extract_unique_references(data, matches, type = "merge")
}
\arguments{
\item{data}{A \code{data.frame} containing bibliographic information.}

\item{matches}{A vector showing which entries in \code{data} are duplicates.}

\item{type}{How should entries be selected to retain? Default is \code{"merge"} which selects the entries with the largest number of characters in each column. Alternatively \code{"select"} which returns the row with the highest total number of characters.}
}
\value{
Returns a \code{data.frame} of unique references.
}
\description{
Given a list of duplicate entries and a data set, this function extracts only unique references.
}
\examples{
my_df <-  data.frame(
  title = c(
    "EviAtlas: a tool for visualising evidence synthesis databases",
    "revtools: An R package to support article screening for evidence synthesis",
    "An automated approach to identifying search terms for systematic reviews",
    "Reproducible, flexible and high-throughput data extraction from primary literature",
    "eviatlas:tool for visualizing evidence synthesis databases.",
    "REVTOOLS a package to support article-screening for evidence synthsis"
  ),
  year = c("2019", "2019", "2019", "2019", NA, NA),
  authors = c("Haddaway et al", "Westgate",
              "Grames et al", "Pick et al", NA, NA),
  stringsAsFactors = FALSE
)

# run deduplication
dups <- find_duplicates(
  my_df$title,
  method = "string_osa",
  rm_punctuation = TRUE,
  to_lower = TRUE
)

extract_unique_references(my_df, matches = dups)

# or, in one line:
deduplicate(my_df, "title",
  method = "string_osa",
  rm_punctuation = TRUE,
  to_lower = TRUE)
}
\seealso{
\code{\link{find_duplicates}}, \code{\link{deduplicate}}
}
