% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_irr.R
\name{get_irr}
\alias{get_irr}
\title{get_irr}
\usage{
get_irr(data, ratings, order_triagelevel)
}
\arguments{
\item{data}{A dataframe}

\item{ratings}{A vector indicating the column names storing the ratings of reach rater}

\item{order_triagelevel}{A vector indicating the order of triage levels. The triage level with highest urgency should be the first value and the triage level with lowest urgency the last value.}
}
\value{
A list containing the inter-rater reliability
}
\description{
Calculates the inter-rater reliability of multiple raters using a two-way, absolute agreement, average-measures, mixed intra-class correlation
}
\examples{
\dontrun{
#' irr <- get_irr(
  data = df,
  ratings = c("datarater1", "datarater2", "datarater3"),
  order_triagelevel = c("Emergency", "Non-Emergency", "Self-care"),
  )
  }
}
