% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{clean_text}
\alias{clean_text}
\title{Clean texts retrieved from WebServices}
\usage{
clean_text(text, keep_round_brackets = T)
}
\arguments{
\item{text}{a character vector.}

\item{keep_round_brackets}{if \code{TRUE}, round brackets and their contents are not deleted.}
}
\value{
A character vector of same length as \code{text}.
}
\description{
\code{clean_text} removes HTML code, brackets and their contents as well as line breaks from texts.
}
\examples{
\dontrun{
# Get clean version of transcripts
get_glimpse(table = "Transcript", rows = 1000, Language = "DE") \%>\%
   mutate(Text2 = clean_text(Text))
}
}
