% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readpal.R
\name{read_palette}
\alias{read_palette}
\title{Read colors from palette files}
\usage{
read_palette(path, use_names = TRUE, .verbose = FALSE)
}
\arguments{
\item{path}{partial or full file path or URL to a GPL file}

\item{use_names}{add color names to the vector (defaults to \code{TRUE}). See NOTE}

\item{.verbose}{show extra information about GPL file processing}
}
\description{
Given a path or URL to an palette file, this function will attempt to determine
which palette file format to read by the file type and return
a named character vector (if color names are present) of hex RGB colors.
}
\note{
When using named color palettes in a \code{ggplot2} \code{scale_} context, you
    must \code{unname}, set \code{use_names} to \code{FALSE} or override their names
    to map to your own factor levels.
}
