% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{linesSymbols}
\alias{linesSymbols}
\title{Adjust line and/or symbol charts}
\usage{
linesSymbols(
  svg,
  frame_name,
  group_name,
  scale_real,
  values,
  alignment = "vertical",
  has_lines = TRUE,
  symbol_type = NULL,
  ...
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{frame_name}{Name (attribute 'id') of frame (XML element 'rect') for positioning of elements.}

\item{group_name}{Name (attribute 'id') of group (XML element 'g') with lines and/or symbols.}

\item{scale_real}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length. Only minimum and maximum are used for scaling of values.}

\item{values}{Numeric vector. If a dataframe or matrix is provided, only the first row will be used.}

\item{alignment}{Character value. Accepts 'horizontal' or 'vertical' (default). See details.}

\item{has_lines}{Are there lines? (default TRUE)}

\item{symbol_type}{Character value. Accepts 'circle', 'rect', 'polygon', 'linegroup', 'path', or 'guess' for guessing of type; see details. (default NULL = no symbols)}

\item{...}{Further arguments used internally by \code{\link{scatterSymbols}}.}
}
\value{
XML document with SVG content
}
\description{
Adjusts the horizontal (XML attributes 'x', 'x1', 'x2', 'cx' etc.) or vertical (XML attributes 'y', 'y1', 'y2', 'cy' etc.) position of lines (XML elements of type 'line') and/or symbols (see details). Positions are calculated relative to a given frame (XML element of type 'rect') and the position of a data value within the minimum and maximum of a given scale. This process is called scaling.\cr
In preparation, it is necessary to name a group (set attribute 'id' of XML element of type 'g') of lines and/or symbols.
}
\details{
Note: 'Horizontal' alignment refers to adjustment of the x-coordinates of elements, 'vertical' alignment to adjustment of the y-coordinates. This is not to be confused with the orientation of the resulting polyline (and/or the sequence of symbols) that goes from left to right (with \code{alignment='vertical'}) or from top to bottom (with \code{alignment='horizontal'}).\cr
Line elements and/or symbols may be grouped together in any order in the SVG file. The function will automatically use XML elements from left to right (with \code{alignment='vertical'}) or top to bottom (with \code{alignment='horizontal'}) according to their x/y-coordinates.\cr
Line elements and/or symbols must be prepared in the SVG file in one of the following amounts: a) same amount as data values (or one element less in case of lines), b) one line and/or or two symbols or c) one line \emph{and} one symbol. In case of b) and c) the function will automatically duplicate line elements and/or symbols with the assumption of fixed shapes (that is, all lines and/or all symbols will look the same as the 'template' that is provided) and constant distance between the elements on the coordinate that will not be adjusted by \code{values} ('x' with \code{alignment='vertical'} or 'y' with \code{alignment='horizontal'}).\cr
The function currently supports the following \code{symbol_type}s:
\itemize{
\item circle: XML elements of type 'circle'. Attributes 'cx' or 'cy' are adjusted.
\item rect: XML elements of type 'rect'. Attributes 'x' or 'y' are adjusted.
\item polygon: XML elements of type 'polygon'. Attribute 'points' is adjusted so that the centroid of the shape matches the scaled value position on the chart.
\item linegroup: XML elements of type 'g' that contain elements of type 'line'. Attributes 'x1' and 'x2' or 'y1' and 'y2' of those lines are adjusted so that the mean x- or y-coordinate of all lines in the group matches the scaled value position on the chart.
\item path: XML elements of type 'path'. The first command of attribute 'd' is adjusted. The center of path is defined as the midpoint between minimum and maximum x- and y-coordinates of the shape.
}
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig11.svg", package="svgtools")
svg <- read_svg(file = fpath)

#adjust lines and/or symbols
set.seed(12345)
values <- matrix(c(rnorm(10,0.95,0.03), rnorm(10,0.75,0.05), 
                   rnorm(10,0.55,0.07), rnorm(10,0.35,0.05), 
                   rnorm(10,0.15,0.03)), nrow = 5, byrow = TRUE)
values[2,8] <- as.numeric(NA)
svg <- linesSymbols(svg = svg, frame_name = "frame", group_name = "gA", 
                    scale_real = c(0,1), values = values[1,], 
                    symbol_type = "rect")
svg <- linesSymbols(svg = svg, frame_name = "frame", group_name = "gB", 
                    scale_real = c(0,1), values = values[2,], 
                    symbol_type = "circle")
svg <- linesSymbols(svg = svg, frame_name = "frame", group_name = "gC", 
                    scale_real = c(0,1), values = values[3,], 
                    has_lines = FALSE, symbol_type = "polygon")
svg <- linesSymbols(svg = svg, frame_name = "frame", group_name = "gD", 
                    scale_real = c(0,1), values = values[4,], 
                    symbol_type = "linegroup")
svg <- linesSymbols(svg = svg, frame_name = "frame", group_name = "gE", 
                    scale_real = c(0,1), values = values[5,], 
                    symbol_type = NULL)
}
