% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_store_value}
\alias{sd_store_value}
\title{Store a value in the survey data}
\usage{
sd_store_value(value, id = NULL, db = NULL, auto_assign = TRUE)
}
\arguments{
\item{value}{The value to be stored. This can be any R object that can be
coerced to a character string.}

\item{id}{(Optional) Character string. The id (name) of the value in the
data. If not provided, the name of the \code{value} variable will be used.}

\item{db}{(Optional) Database connection object created with sd_db_connect().
If provided, enables session persistence. If not provided, will automatically
look for a variable named 'db' in the calling environment, or fall back to
the database connection from the session.}

\item{auto_assign}{Logical. If \code{TRUE} (default), automatically assigns the
stored value back to the original variable in the calling environment.
This eliminates the need for explicit assignment when session persistence
is desired. If \code{FALSE}, the function only returns the value without
modifying the original variable.}
}
\value{
The value that was stored (either the new value or existing value
from database if session persistence applies). This allows the function
to be used in variable assignments.
}
\description{
This function allows storing additional values to be included in the survey
data, such as respondent IDs or other metadata. When a database connection
is provided, it implements session persistence - if a value already exists
for the current session, storage is skipped to maintain consistency across
page refreshes.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_store_value() to store custom values in the database:
  # server <- function(input, output, session) {
  #   # Store a generated value
  #   respondentID <- sample(1:1000, 1)
  #   sd_store_value(respondentID, "respID", db)
  #
  #   # Store with automatic ID detection
  #   completion_code <- sample(0:9, 6, replace = TRUE)
  #   sd_store_value(completion_code, db = db)
  #
  #   # Store without auto-assignment
  #   stored_val <- sd_store_value(42, "my_value", db, auto_assign = FALSE)
  #
  #   sd_server()
  # }

  # Find a working directory and start from a template:
  sd_create_survey(template = "reactive_questions")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
