% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.r
\name{traits.to.string}
\alias{traits.to.string}
\title{Take a set of traits and turn into a string}
\usage{
traits.to.string(data, traits, na.action = "drop", sep = ".")
}
\arguments{
\item{data}{The respondent info}

\item{traits}{The names of the traits to build the model on}

\item{na.action}{Defaults to 'drop' (meaning all rows of data
with any missingness on the traits are dropped). Anything else
means \code{NA}s are treated like any other value.}

\item{sep}{The separator character used to combine values}
}
\value{
A list whose entries are
\itemize{
\item \code{used.idx}, which indicates which rows from the original dataset were used
(may not be all of them if there is missingness); and
\item \code{traits}, which has the string version of the traits
}
}
\description{
This is a helper function that is useful when we wish
to make several traits into one variable
}
\keyword{internal}
