#' Run Survey Simulation 'Shiny' App
#'
#' Launches the 'Shiny' app for finite population total estimation under SRSWOR.
#'
#' @return Launches a 'Shiny' application.
#' @examples
#' if (interactive()) {
#'   run_survey_sim_app()
#' }
#' @export
run_survey_sim_app <- function() {
  app_dir <- system.file("shiny", package = "surveySimR")
  if (app_dir == "") {
    stop("Could not find 'Shiny' app directory. Try re-installing `surveySimR`.", call. = FALSE)
  }
  shiny::runApp(app_dir, display.mode = "normal")
}
