% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survSRF_stack.R
\name{survsrfstack_cv}
\alias{survsrfstack_cv}
\title{Cross-validates stacked ensemble of the CoxPH and Survival Random Forest models}
\usage{
survsrfstack_cv(
  df,
  predict.factors,
  fixed_time = NaN,
  outer_cv = 3,
  inner_cv = 3,
  repeat_cv = 2,
  randomseed = NaN,
  return_models = FALSE,
  useCoxLasso = FALSE,
  tuningparams = list(),
  max_grid_size = 10,
  verbose = FALSE,
  suppresswarn = TRUE,
  impute = 0,
  impute_method = "missForest"
)
}
\arguments{
\item{df}{data, "time" and "event" should describe survival outcome}

\item{predict.factors}{list of predictor names}

\item{fixed_time}{time at which performance is maximized}

\item{outer_cv}{number of cross-validation folds for model validation}

\item{inner_cv}{number of cross-validation folds for hyperparameters' tuning}

\item{repeat_cv}{number of CV repeats, if NaN, runs once}

\item{randomseed}{random seed to control tuning including data splits}

\item{return_models}{TRUE/FALSE, if TRUE returns all CV objects}

\item{useCoxLasso}{if CoxLasso is used (TRUE) or not (FALSE, default)}

\item{tuningparams}{if given, list of hyperparameters, list(mtry=c(), nodedepth=c(),nodesize=c()), otherwise a wide default grid is used}

\item{max_grid_size}{number of random grid searches for model tuning}

\item{verbose}{FALSE(default)/TRUE}

\item{suppresswarn}{TRUE/FALSE, TRUE by default}

\item{impute}{0/1/2/3 for no imputation / option 1 (proper way) / option 2 (faster way) / option 3 (complete cases), more in documentation and vignette}

\item{impute_method}{"missForest"}
}
\description{
Cross-validates stacked ensemble of the CoxPH and Survival Random Forest models
}
