% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.survHE.R
\name{print.survHE}
\alias{print.survHE}
\title{Print a summary of the survival model(s) fitted by \code{fit.models}}
\usage{
\method{print}{survHE}(x, mod = 1, ...)
}
\arguments{
\item{x}{the \code{survHE} object (the output of the call to
\code{fit.models})}

\item{mod}{is the index of the model. Default value is 1, but the user can
choose which model fit to visualise, if the call to fit.models has a vector
argument for distr (so many models are fitted & stored in the same object)}

\item{\dots}{additional options, including: \code{digits} = number of
significant digits to be shown in the summary table (default = 6);
\code{original} = a flag to say whether the \emph{original} table
from either \code{flexsurv} or \code{INLA} or \code{rstan} should be printed;
\code{print_priors} = a flag to say whether the distributional assumptions
for the HMC model (only)}
}
\description{
Prints the summary table for the model(s) fitted, with the estimate of the
parameters
}
\examples{
\dontrun{ 
data(bc)

mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
print(mle)
}

}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. \url{doi:10.18637/jss.v095.i14}
}
\author{
Gianluca Baio
}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
