% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ah1.R
\name{ah1}
\alias{ah1}
\title{Average Hazard (one sample)}
\usage{
ah1(time, status, tau, conf.int=0.95)
}
\arguments{
\item{time}{A numeric vector of follow-up times for right-censored data.}

\item{status}{A numeric vector indicating the event status; 1 = event occurred, 0 = right censored.}

\item{tau}{A scalar specifying the end time point (\code{tau}) for calculating the average hazard. If \code{tau = NULL}, the default is the maximum time point at which the risk set size in both groups is at least 10.}

\item{conf.int}{A numeric value specifying the confidence level for confidence intervals. The default is \code{0.95}.}
}
\value{
An object of class \code{ah1}, which contains the following components:

\item{need_stop}{Logical indicator. If \code{TRUE}, specify another \code{tau}. The survival probability at the specified \code{tau} needs to be > 0.}

\item{tau}{The truncation time point used in the analysis.}

\item{result1}{Estimated average hazard.}
}
\description{
Calculates the average hazard with survival weight and the corresponding asymptotic confidence interval for a single sample.
}
\details{
It also provides the log-transformed t-year event rate and restricted mean survival time (RMST) along with their variances as intermediate products.
Note that the confidence intervals for the t-year event rate and RMST are based on log-scale values. As a result, the confidence intervals may differ slightly from those generated by the \pkg{surv2sampleComp} or \pkg{survRM2} packages.
}
\examples{
#====================================================================
# cm214_pfs: The sample reconstructed data of the CheckMate214 study.
# The code below reproduces the results reported by
# Uno and Horiguchi (StatMed; 2023) in Table 6.
#====================================================================
D      = cm214_pfs
time   = D$time
status = D$status
tau    = 21

b = ah1(time=time, status=status, tau=tau, conf.int=0.95)
print(b)
}
\references{
Uno H and Horiguchi M. Ratio and difference of average hazard with survival weight: new measures to quantify survival benefit of new therapy. Statistics in Medicine. 2023;1-17. <doi:10.1002/sim.9651>
}
\author{
Hajime Uno, Miki Horiguchi
}
