% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_circular.R
\name{superbPlot.circularline}
\alias{superbPlot.circularline}
\title{superbPlot 'circularline' layout}
\usage{
superbPlot.circularline(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata = NULL,
  pointParams = list(),
  lineParams = list(),
  errorbarParams = list(),
  facetParams = list(),
  radarParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{pointParams}{(optional) list of graphic directives that are sent to the \code{geom_bar()} layer}

\item{lineParams}{(optional) list of graphic directives that are sent to the \code{geom_line()} layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the \code{geom_superberrorbar()} layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the \code{facet_grid()} layer}

\item{radarParams}{(optional)  list of arguments to the radar coordinates (seel \code{coord_radial()} ).}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should be continuous or discrete (default is discrete)}
}
\value{
a ggplot object
}
\description{
superb comes with a few circular layouts for making plots.
It produces ggplot objects that can be further customized.
}
\details{
A few things to note:
\itemize{
\item You can at any time undo the polar coordinates by using
\code{ + coord_cartesian()}. It is sometimes easier when developping the plots.
\item Also, if ever you want to modify the scale post-hoc (e.g., to change
the labels of the group), you can, but your \code{scale_x_continuous} \strong{must
absolutely} contains the two arguments:
scale_x_continuous(
oob = scales::oob_keep,
limits = c(0, 0.00001+ \emph{NUMBER OF CONDITIONS} ),
# any other argument such as labels = c("",...)
)
}

It has these parameters:
}
\examples{
# This will make a plot with lines
superb(
   len ~ dose + supp, 
   ToothGrowth, 
   plotLayout="circularline" 
)

# if you extract the data with superbData, you can 
# run this layout directly
#processedData <- superb(
#   len ~ dose + supp,
#   ToothGrowth, 
#   showPlot = FALSE
#)
#
#superbPlot.circularline(processedData$summaryStatistic,
#   "dose",
#   "supp",
#   ".~.",
#   processedData$rawData)

}
