% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-non-nums.R
\name{str_extract_non_numerics}
\alias{str_extract_non_numerics}
\title{Extract non-numbers from a string.}
\usage{
str_extract_non_numerics(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  commas = FALSE
)
}
\arguments{
\item{string}{A string.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{big_mark}{A character. Allow this character to be used as a thousands
separator. This character will be removed from between digits before they
are converted to numeric. You may specify many at once by pasting them
together e.g. \code{big_mark = ",_"} will allow both commas and underscores.
Internally, this will be used inside a \verb{[]} regex block so e.g. \code{"a-z"}
will behave differently to \code{"az-"}. Most common separators (commas, spaces,
underscores) should work fine.}

\item{commas}{Deprecated. Use \code{big_mark} instead.}
}
\description{
Extract the non-numeric bits of a string where numbers are optionally defined
with decimals, scientific notation and thousand separators.
}
\details{
\itemize{ \item \code{str_first_non_numeric(...)} is just
\code{str_nth_non_numeric(..., n = 1)}. \item \code{str_last_non_numeric(...)} is just
\code{str_nth_non_numeric(..., n = -1)}. }
}
\examples{
strings <- c(
  "abc123def456", "abc-0.12def.345", "abc.12e4def34.5e9",
  "abc1,100def1,230.5", "abc1,100e3,215def4e1,000"
)
str_extract_non_numerics(strings)
str_extract_non_numerics(strings, decimals = TRUE, leading_decimals = FALSE)
str_extract_non_numerics(strings, decimals = TRUE)
str_extract_non_numerics(strings, big_mark = ",")
str_extract_non_numerics(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE
)
str_extract_non_numerics(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE, big_mark = ",", negs = TRUE
)
str_extract_non_numerics(c("22", "1.2.3"), decimals = TRUE)
}
\seealso{
Other non-numeric extractors: 
\code{\link{str_nth_non_numeric}()}
}
\concept{non-numeric extractors}
