% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_of_other_authors.R
\name{fpia}
\alias{fpia}
\alias{fpia2}
\title{Optimal Univariate Allocation Under Constraints for Stratified
Sampling}
\usage{
fpia(
  n,
  Ah,
  mh = NULL,
  Mh = NULL,
  lambda0 = NULL,
  maxiter = 100,
  tol = .Machine$double.eps * 1000
)

fpia2(v0, Nh, Sh, mh = NULL, Mh = NULL, lambda0 = NULL, maxiter = 100)
}
\arguments{
\item{n}{\itemize{
\item target sample size for allocation.
}}

\item{Ah}{\itemize{
\item population strata sizes * standard deviations of a given variable in strata.
}}

\item{mh}{\itemize{
\item lower constraints for sample sizes in strata.
}}

\item{Mh}{\itemize{
\item upper constraints for sample sizes in strata.
}}

\item{lambda0}{\itemize{
\item initial parameter 'lambda' (optional).
}}

\item{maxiter}{\itemize{
\item maximal number of iterations for algorithm.
}}

\item{tol}{\itemize{
\item the desired accuracy (convergence tolerance).
}}

\item{v0}{\itemize{
\item upper limit for value of variance which must be attained for
computed optimal allocation.
}}

\item{Nh}{\itemize{
\item population strata sizes.
}}

\item{Sh}{\itemize{
\item standard deviations of a given variable in strata.
}}
}
\value{
A vector of optimal allocation sizes, and number of iterations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Algorithm for optimal allocation in stratified sampling with lower and upper
constraints based on fixed point iteration.
}
\section{Functions}{
\itemize{
\item \code{fpia2()}: 

}}
\references{
Münnich, R. T., Sachs, E.W. and Wagner, M. (2012)
Numerical solution of optimal allocation problems in stratified sampling
under box constraints,
\emph{AStA Advances in Statistical Analysis}, 96(3), pp. 435-450.
\doi{10.1007/s10182-011-0176-z}
}
