% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{fct2v}
\alias{fct2v}
\title{Factor to (Atomic) Vector}
\usage{
fct2v(fct, simplify = TRUE, codes = FALSE, check = TRUE)
}
\arguments{
\item{fct}{factor.}

\item{simplify}{logical vector of length 1 specifying whether R should attempt to
simplify \code{fct} to typeof simplier than character (e.g., logical, integer, double).
If FALSE, a character vector is always returned.}

\item{codes}{logical vector of length 1 specifying whether the integer codes of
\code{fct} should be returned. If \code{codes} = TRUE, then \code{simplify} is ignored.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{fct} is a factor.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector of the same length as \code{fct}. If \code{codes} = TRUE,
then the returned vector is typeof integer containing the underlying factor codes.
If \code{codes} = FALSE and \code{simplify} = FALSE, then the returned vector is
typeof character containing the factor levels. If \code{codes} = FALSE, and
\code{simplify} = TRUE, then the returned vector is the simpliest typeof possible
without having to coerce any elements to NA. For example, if \code{fct} contains
all integer numerals (e.g., "1", "2", "3", etc), then it will be converted to an
integer vector. See examples.
}
\description{
\code{fct2v} converts a factor to an (atomic) vector. It allows the user to specify
whether they want the factor to always return a character vector (\code{simplify = TRUE}),
simplified if possible (\code{simplify = FALSE}), or just return the integer codes
(\code{codes = TRUE}).
}
\details{
When \code{simplify = TRUE}, \code{fct2v} uses \code{type.convert} to try to simplify
the factor. Note, missing values are assumed to be "NA" and decimals are assumed
to be "."; however, "L" after a number is not interpreted as an integer specifier.
}
\examples{
fct2v(state.region)
fct2v(fct = factor(c("7.00001","8.54321","9.99999"))) # double
fct2v(fct = factor(c("7","8","9")), simplify = FALSE) # character
fct2v(fct = factor(c("7","8","9")), simplify = TRUE) # integer
fct2v(fct = factor(c("7","8","9")), codes = TRUE) # integer codes
fct2v(fct = factor(c("7L","8L","9L")),
   simplify = TRUE) # does not understand "L" for integers
}
