% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psim_artif.R
\name{psim_artif}
\alias{psim_artif}
\title{Stpp from synthetic origins}
\usage{
psim_artif(n_events=1000, start_date = "2021-01-01",
poly, netw = NULL, n_origin, restriction_feat=NULL, field,
n_foci, foci_separation, mfocal = NULL, conc_type = "dispersed",
p_ratio=20, s_threshold = 50, step_length = 20,
trend = "stable", shortTerm = "cyclical", fPeak=90,
s_band = c(0, 200),
t_band = c(1, 5, 10),
slope = NULL, interactive = FALSE, show.plot=FALSE, show.data=FALSE, ...)
}
\arguments{
\item{n_events}{number of points
(events) to simulate. Default: \code{1000}.
A vector of integer values can be supplied, such as,
c(\code{a}1, \code{a}2, ....)\verb{, where }a\verb{1, }a`2, ...
represent different integer values.}

\item{start_date}{the start date of the temporal pattern.
The date should be in the format \code{"yyyy-mm-dd"}.
The 'gtp' will normally cover a 1-year period.}

\item{poly}{(An sf or S4 object)
a polygon shapefile defining the extent of the landscape.}

\item{netw}{(An sf or S4 object)
The network path of the landscape
(e.g. road and/or street). Default: \code{NULL}.
If provided each event is snapped to the closest
network path/segment.}

\item{n_origin}{number of locations to serve as
origins for walkers. Default:\code{50}.}

\item{restriction_feat}{(An S4 object) optional
shapefile containing features
in which walkers cannot walk through.
Default: \code{NULL}.}

\item{field}{a number in the range of \code{[0-1]}
(i.e. restriction values) assigned
to all features; or
the name of a numeric field to extract such
restriction values for different classes of
feature.
Restriction value \code{0} and \code{1} indicate the
lowest and the highest obstructions, respectively.
Default: \code{NULL}.}

\item{n_foci}{number of focal points amongst the origin
locations. The origins to serve as focal
points are based on random selection. \code{n_foci} must be
smaller than \code{n_origins}.}

\item{foci_separation}{a value from \code{1} to \code{100}
indicating the nearness of focal points to one another.
A \code{0} separation indicates that focal points are in
close proximity
of one another, while a \code{100} indicates focal points being
evenly distributed across space.}

\item{mfocal}{the c(x, y) coordinates of a single point,
representing a pre-defined \code{main} focal point (origin)
in the area. The default is \code{NULL} in which a random
coordinate is chosen within the \code{polygon} area.}

\item{conc_type}{concentration of the rest of the
origins (non-focal origins) around the focal ones. The options
are \code{"nucleated"} and \code{"dispersed"}.}

\item{p_ratio}{the smaller of the
two terms of proportional ratios.
For example, a value of \code{20}
implies \code{20:80} proportional ratios.}

\item{s_threshold}{defines the spatial
perception range of a walker at a given
location. Default: \code{250} (in the same
linear unit
as the \code{poly} - polygon shapefile).}

\item{step_length}{the maximum step taken
by a walker from one point to the next.}

\item{trend}{specifies the direction of the
long-term trend. Options are:
\code{"falling"}, \code{"stable"},
and \code{"rising"}. Default value is: \code{"stable"}.}

\item{shortTerm}{type of short- to medium-term
fluctuations (patterns) of the time series.
Options are: \code{`"cyclical"` and `"acyclical"`}.
Default is: \code{`"cyclical"`}.}

\item{fPeak}{first seasonal
peak of cyclical short term. Default value is \code{90}.
Only used for \code{"cyclical"} short term pattern.}

\item{s_band}{distance bandwidth within which
the event re-occurences are maximized (i.e.,
interactions are maximum). Specified as a vector of
two distance values. Default: \code{c(0, 200)}.}

\item{t_band}{temporal bandwidth within which
event re-occurences are maximized (i.e., interactions
are maximum). Specified as a vector of values (in days)
\code{c(1, 5, 7, 14)}.}

\item{slope}{slope of the long-term trend when
an \code{"rising"} or \code{"falling"} trend is specified.
Options: \code{"gentle"} or \code{"steep"}. The default value is
set as \code{NULL} for the \code{stable} trend.}

\item{interactive}{Whether to run the process in
interactive mode. Default is \code{FALSE}. If \code{TRUE},
a user is able to preview the spatial and temporal models
of the expected distribution of the final simulated
events (points).}

\item{show.plot}{(logical) Shows GTP.
Default is \code{FALSE}.}

\item{show.data}{(TRUE or FALSE) To show the output
data. Default is \code{FALSE}.}

\item{...}{additional arguments to pass from
\code{gtp}, \code{walker} and \code{artif_spo}
functions.}
}
\value{
Returns a list of artificial spatiotemporal
point patterns based on user-defined parameters.
}
\description{
Generates spatiotemporal
point patterns based on a set of
synthesized origins.
}
\details{
Simulate artificial spatiotemporal patterns
and interactions based user specifications.
}
\examples{
\dontrun{

#load boundary and land use of Camden
#load(file = system.file("extdata", "camden.rda",
#package="stppSim"))
#boundary = camden$boundary # get boundary
#landuse = camden$landuse # get landuse
boundary <- stppSim:::boundary
landuse <- stppSim:::landuse
#In this example, we will use a minimal number of
#'n_origin' (i.e. `20`) for faster computation:

#simulate data
simulated_stpp <- psim_artif(n_events=200, start_date = "2021-01-01",
poly=boundary, netw = NULL, n_origin=20, restriction_feat = NULL,
field = NULL,
n_foci=1, foci_separation = 10, mfocal = NULL,
conc_type = "dispersed",
p_ratio = 20, s_threshold = 50,
step_length = 20,
trend = "stable", shortTerm = "cyclical",
fPeak=90, s_band = c(0, 200),
t_band = c(1, 5, 10),
slope = NULL, interactive = FALSE, show.plot=FALSE, show.data=FALSE)

#If `n_events` is a vector of values,
#retrieve the simulated data for the
#corresponding vector element by using
#`simulated_stpp[[enter-element-index-here]]`, e.g.,
#to retrieve the first dataframe, use
#simulated_stpp[[1]].

#The above example simulates point patterns on
#an unrestricted landscape. If set ,
#`restriction_feat = landuse` and
#`field = "restrVal"`, then the simulation
#is performed on a restricted landscape.
}

}
