% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlap_matrix}
\alias{overlap_matrix}
\title{Matrix of overlaps between two sets of areas.}
\usage{
overlap_matrix(dom1, dom2, proportion = TRUE)
}
\arguments{
\item{dom1}{An \code{sf} object representing a domain of areal units.}

\item{dom2}{An \code{sf} object representing a domain of areal units.}

\item{proportion}{Logical; if \code{TRUE}, normalize so that rows sum to 1.
Otherwise areas are returned.}
}
\value{
An matrix of overlaps.
}
\description{
A convenience function to convert output from \code{sf::st_intersection}
to a sparse matrix as defined in the \code{Matrix} package.
}
\details{
Returns a matrix \code{H} whose (i,j)th entry represent the area of the overlap
between areal units \code{dom1[i,]} and \code{dom2[j,]}.
}
\examples{
data("acs_sf")
dom1 = acs5_2013[1:10,]
dom2 = acs5_2016[1:10,]
H1 = overlap_matrix(dom1, dom2)
H2 = overlap_matrix(dom1, dom2, proportion = FALSE)

}
