% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.median.ps}
\alias{ci.ratio.median.ps}
\title{Confidence interval for a paired-samples median ratio}
\usage{
ci.ratio.median.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for measurement 1}

\item{y2}{vector of scores for measurement 2 (paired with y1)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for measurement 1
\item Median2 - estimated median for measurement 2
\item Median1/Median2 - estimated ratio of medians
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a ratio of population
medians in a paired-samples design. Ratio-scale measurements are assumed.
Tied scores within each measurement are assumed to be rare.

For more details, see Section 4.23 of Bonett (2021, Volume 1)
}
\examples{
y1 = c(76.41, 66.91, 81.06, 74.78, 83.76, 89.31, 78.78, 87.06, 82.61, 76.74, 88.33, 86.18)
y2 = c(59.85, 60.64, 84.86, 68.16, 71.53, 86.18, 67.30, 65.46, 83.50, 66.76, 88.37, 65.02)
ci.ratio.median.ps(.05, y1, y2)

# Should return:
# Median1  Median2  Median1/Median2        LL        UL
#  81.835    67.73         1.208253  1.069251  1.365326


}
\references{
\insertRef{Bonett2020b}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
