% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median}
\alias{ci.median}
\title{Confidence interval for a median}
\usage{
ci.median(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated median
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a population median.
Tied scores are assumed to be rare.

For more details, see Section 1.25 of Bonett (2021, Volume 1)
}
\examples{
y <- c(25, 29, 35, 36, 36, 40, 41, 43, 44, 54)
ci.median(.05, y)

# Should return:
#  Estimate       SE  LL  UL
#        38 3.261774  29  44


}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
