#' Phenotypic data for awn length in barley
#'
#' @format A data.frame with 916 rows and 3 columns.
#' \describe{
#' \item{genotype}{Genotype}
#' \item{Awn_length}{Awn_length in mm.}
#' \item{cross}{The cross the genotype belongs to.}
#' }
#' @references Fine mapping of a major QTL for awn length in barley using a
#' multiparent mapping population. Liller CB, Walla A, Boer MP, Hedley P,
#' Macaulay M, Effgen S, von Korff M, van Esse GW, Koornneef M.
#' Theor Appl Genet. 2017 Feb;130(2):269-281. \doi{10.1007/s00122-016-2807-y}.
"barleyPheno"

#' Pre-computed SQM output maize
#'
#' Pre-computed SQM output for maize data used in vignette.
"maizeSQM"

#' Pre-computed MQM output maize
#'
#' Pre-computed MQM output for maize data used in vignette.
"maizeMQM"

#' Pre-computed MQM output barley
#'
#' Pre-computed MQM output for barley data used in vignette.
"barleyMQM"
