% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.psHDM.R
\name{plot.psHDM}
\alias{plot.psHDM}
\title{Plot function for class psHDM}
\usage{
\method{plot}{psHDM}(
  x,
  ...,
  plotType = c("popTra", "popGenoTra", "popGenoDeriv", "genoDev", "genoPlotTra"),
  genotypes = NULL,
  genotypeNames = NULL,
  genotypeOrder = NULL,
  xlab = "Time",
  ylab = expression(tilde(y)[pgi](t)),
  title = NULL,
  themeSizeHDM = 15,
  output = TRUE,
  outFile = NULL,
  outFileOpts = NULL
)
}
\arguments{
\item{x}{An object of class "psHDM" as obtained after fitting
(\code{\link{fitSplineHDM}}) or predicting (\code{\link{predict.psHDM}}),}

\item{...}{Not used.}

\item{plotType}{A character string indicating which plot should be made.}

\item{genotypes}{A character vector with the genotypes for which plots at
plot level are desired. Only used when \code{plotType == "genoPlotTra"}.}

\item{genotypeNames}{A character vector with alternative names for the
plotted genotypes (genotypes). If \code{NULL} the names of the genotypes
are used. Only used when \code{plotType == "genoPlotTra"}.}

\item{genotypeOrder}{A vector with the order of the selected genotypes
(genotypes). If \code{NULL} then the order in the data is preserved.
Only used when \code{plotType == "genoPlotTra"}.}

\item{xlab}{The x-axis label of the plot.}

\item{ylab}{The y-axis label of the plot.}

\item{title}{A character string used as title for the plot. If \code{NULL} a
default title is added to the plot depending on \code{plotType}.}

\item{themeSizeHDM}{Reference size for the theme}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a (list of) ggplot object(s) is invisibly returned. Ignored if
\code{outFile} is specified.}

\item{outFile}{A character string indicating the .pdf file to which the
plots should be written. If \code{NULL}, no file is written.}

\item{outFileOpts}{A named list of extra options for the pdf outfile, e.g.
width and height. See \code{\link[grDevices]{pdf}} for all possible options.}
}
\description{
This plot function provides five plots for objects of the class \code{psHDM}
after fitting (\code{\link{fitSplineHDM}}) or predicting
(\code{\link{predict.psHDM}}): (1) Population-specific growth curves (popTra),
(2) Population and genotype-specific growth curves (for all genotypes, popGenoTra),
(3) First-order derivative of the population and genotype-specific growth curves
(for all genotypes, popGenoDeriv), (4) Genotype-specific deviations (for all
genotypes, genoDev), and (5) Genotype- and plot-specific growth curves (for a
selection of genotypes, genoPlotTra). If standard errors are available, 95\% point
wise confidence intervals are depicted.
}
\examples{
## The data from the Phenovator platform have been corrected for spatial
## trends and outliers for single observations have been removed.

## We need to specify the genotype-by-treatment interaction.
## Treatment: water regime (WW, WD).
spatCorrectedArch[["treat"]] <- substr(spatCorrectedArch[["geno.decomp"]],
                                      start = 1, stop = 2)
spatCorrectedArch[["genoTreat"]] <-
  interaction(spatCorrectedArch[["genotype"]],
             spatCorrectedArch[["treat"]], sep = "_")

## Fit P-Splines Hierarchical Curve Data Model for selection of genotypes.
fit.psHDM  <- fitSplineHDM(inDat = spatCorrectedArch,
                          trait = "LeafArea_corr",
                          genotypes = c("GenoA14_WD", "GenoA51_WD",
                                       "GenoB11_WW", "GenoB02_WD",
                                       "GenoB02_WW"),
                          time = "timeNumber",
                          pop = "geno.decomp",
                          genotype = "genoTreat",
                          plotId = "plotId",
                          difVar = list(geno = FALSE, plot = FALSE),
                          smoothPop = list(nseg = 4, bdeg = 3, pord = 2),
                          smoothGeno = list(nseg = 4, bdeg = 3, pord = 2),
                          smoothPlot = list(nseg = 4, bdeg = 3, pord = 2),
                          weights = "wt",
                          trace = FALSE)

## Plot the P-Spline predictions at the three levels of the hierarchy

## Population-specific growth curves.
plot(fit.psHDM,
    plotType = "popTra")

## Population and genotype-specific growth curves.
plot(fit.psHDM,
    plotType = "popGenoTra")

## First-order derivative of the population- and genotype-specific growth curves.
plot(fit.psHDM,
    plotType = "popGenoDeriv")

## Genotype-specific deviations.
plot(fit.psHDM,
    plotType = "genoDev")

## Genotype- and plot-specific growth curves.
plot(fit.psHDM,
    plotType = "genoPlotTra")

}
\references{
Pérez-Valencia, D.M., Rodríguez-Álvarez, M.X., Boer, M.P. et al.
A two-stage approach for the spatio-temporal analysis of high-throughput
phenotyping data. Sci Rep 12, 3177 (2022). \doi{10.1038/s41598-022-06935-9}
}
\seealso{
Other functions for fitting hierarchical curve data models: 
\code{\link{fitSplineHDM}()},
\code{\link{predict.psHDM}()}
}
\concept{functions for fitting hierarchical curve data models}
